/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 *  USB HID quirks support for Linux
 *
 *  Copyright (c) 1999 Andreas Gal
 *  Copyright (c) 2000-2005 Vojtech Pavlik <vojtech@suse.cz>
 *  Copyright (c) 2005 Michael Haboustak <mike-@cinci.rr.com> for Concept2, Inc
 *  Copyright (c) 2006-2007 Jiri Kosina
 */

/*
 */

#ifndef HID_IDS_H_FILE
#define HID_IDS_H_FILE

#define USB_VENDOR_ID_258A		0x258a
#define USB_DEVICE_ID_258A_6A88		0x6a88

#define USB_VENDOR_ID_3M		0x0596
#define USB_DEVICE_ID_3M1968		0x0500
#define USB_DEVICE_ID_3M2256		0x0502
#define USB_DEVICE_ID_3M3266		0x0506

#define USB_VENDOR_ID_A4TECH		0x09da
#define USB_DEVICE_ID_A4TECH_WCP32PU	0x0006
#define USB_DEVICE_ID_A4TECH_X5_005D	0x000a
#define USB_DEVICE_ID_A4TECH_RP_649	0x001a
#define USB_DEVICE_ID_A4TECH_NB_95	0x022b

#define USB_VENDOR_ID_AASHIMA		0x06d6
#define USB_DEVICE_ID_AASHIMA_GAMEPAD	0x0025
#define USB_DEVICE_ID_AASHIMA_PREDATOR	0x0026

#define USB_VENDOR_ID_ACECAD		0x0460
#define USB_DEVICE_ID_ACECAD_FLAIR	0x0004
#define USB_DEVICE_ID_ACECAD_302	0x0008

#define USB_VENDOR_ID_ACRUX		0x1a34

#define USB_VENDOR_ID_ACTIONSTAR	0x2101
#define USB_DEVICE_ID_ACTIONSTAR_1011	0x1011

#define USB_VENDOR_ID_ADS_TECH		0x06e1
#define USB_DEVICE_ID_ADS_TECH_RADIO_SI470X	0xa155

#define USB_VENDOR_ID_AFATECH		0x15a4
#define USB_DEVICE_ID_AFATECH_AF9016	0x9016

#define USB_VENDOR_ID_AIPTEK		0x08ca
#define USB_DEVICE_ID_AIPTEK_01		0x0001
#define USB_DEVICE_ID_AIPTEK_10		0x0010
#define USB_DEVICE_ID_AIPTEK_20		0x0020
#define USB_DEVICE_ID_AIPTEK_21		0x0021
#define USB_DEVICE_ID_AIPTEK_22		0x0022
#define USB_DEVICE_ID_AIPTEK_23		0x0023
#define USB_DEVICE_ID_AIPTEK_24		0x0024

#define USB_VENDOR_ID_AIRCABLE		0x16CA
#define USB_DEVICE_ID_AIRCABLE1		0x1502

#define USB_VENDOR_ID_AIREN		0x1a2c
#define USB_DEVICE_ID_AIREN_SLIMPLUS	0x0002

#define USB_VENDOR_ID_AKAI		0x2011
#define USB_DEVICE_ID_AKAI_MPKMINI2	0x0715

#define USB_VENDOR_ID_AKAI_09E8		0x09E8
#define USB_DEVICE_ID_AKAI_09E8_MIDIMIX	0x0031

#define USB_VENDOR_ID_ALCOR		0x058f
#define USB_DEVICE_ID_ALCOR_USBRS232	0x9720
#define USB_DEVICE_ID_ALCOR_MALTRON_KB 0x9410

#define USB_VENDOR_ID_ALPS		0x0433
#define USB_DEVICE_ID_IBM_GAMEPAD	0x1101

#define USB_VENDOR_ID_ALPS_JP		0x044E
#define HID_DEVICE_ID_ALPS_U1_DUAL	0x120B
#define HID_DEVICE_ID_ALPS_U1		0x1215
#define HID_DEVICE_ID_ALPS_U1_UNICORN_LEGACY         0x121E
#define HID_DEVICE_ID_ALPS_T4_BTNLESS	0x120C

#define USB_VENDOR_ID_AMI		0x046b
#define USB_DEVICE_ID_AMI_VIRT_KEYBOARD_AND_MOUSE	0xff10

#define USB_VENDOR_ID_ANTON		0x1130
#define USB_DEVICE_ID_ANTON_TOUCH_PAD	0x3101

#define USB_VENDOR_ID_APPLE		0x05ac
#define BT_VENDOR_ID_APPLE		0x004c
#define USB_DEVICE_ID_APPLE_MIGHTYMOUSE	0x0304
#define USB_DEVICE_ID_APPLE_MAGICMOUSE	0x030d
#define USB_DEVICE_ID_APPLE_MAGICMOUSE2	0x0269
#define USB_DEVICE_ID_APPLE_MAGICTRACKPAD	0x030e
#define USB_DEVICE_ID_APPLE_MAGICTRACKPAD2	0x0265
#define USB_DEVICE_ID_APPLE_FOUNTAIN_ANSI	0x020e
#define USB_DEVICE_ID_APPLE_FOUNTAIN_ISO	0x020f
#define USB_DEVICE_ID_APPLE_GEYSER_ANSI	0x0214
#define USB_DEVICE_ID_APPLE_GEYSER_ISO	0x0215
#define USB_DEVICE_ID_APPLE_GEYSER_JIS	0x0216
#define USB_DEVICE_ID_APPLE_GEYSER3_ANSI	0x0217
#define USB_DEVICE_ID_APPLE_GEYSER3_ISO	0x0218
#define USB_DEVICE_ID_APPLE_GEYSER3_JIS	0x0219
#define USB_DEVICE_ID_APPLE_GEYSER4_ANSI	0x021a
#define USB_DEVICE_ID_APPLE_GEYSER4_ISO	0x021b
#define USB_DEVICE_ID_APPLE_GEYSER4_JIS	0x021c
#define USB_DEVICE_ID_APPLE_ALU_MINI_ANSI	0x021d
#define USB_DEVICE_ID_APPLE_ALU_MINI_ISO	0x021e
#define USB_DEVICE_ID_APPLE_ALU_MINI_JIS	0x021f
#define USB_DEVICE_ID_APPLE_ALU_ANSI	0x0220
#define USB_DEVICE_ID_APPLE_ALU_ISO	0x0221
#define USB_DEVICE_ID_APPLE_ALU_JIS	0x0222
#define USB_DEVICE_ID_APPLE_WELLSPRING_ANSI	0x0223
#define USB_DEVICE_ID_APPLE_WELLSPRING_ISO	0x0224
#define USB_DEVICE_ID_APPLE_WELLSPRING_JIS	0x0225
#define USB_DEVICE_ID_APPLE_GEYSER4_HF_ANSI	0x0229
#define USB_DEVICE_ID_APPLE_GEYSER4_HF_ISO	0x022a
#define USB_DEVICE_ID_APPLE_GEYSER4_HF_JIS	0x022b
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_ANSI	0x022c
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_ISO	0x022d
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_JIS	0x022e
#define USB_DEVICE_ID_APPLE_WELLSPRING2_ANSI	0x0230
#define USB_DEVICE_ID_APPLE_WELLSPRING2_ISO	0x0231
#define USB_DEVICE_ID_APPLE_WELLSPRING2_JIS	0x0232
#define USB_DEVICE_ID_APPLE_WELLSPRING3_ANSI	0x0236
#define USB_DEVICE_ID_APPLE_WELLSPRING3_ISO	0x0237
#define USB_DEVICE_ID_APPLE_WELLSPRING3_JIS	0x0238
#define USB_DEVICE_ID_APPLE_WELLSPRING4_ANSI	0x023f
#define USB_DEVICE_ID_APPLE_WELLSPRING4_ISO	0x0240
#define USB_DEVICE_ID_APPLE_WELLSPRING4_JIS	0x0241
#define USB_DEVICE_ID_APPLE_WELLSPRING4A_ANSI	0x0242
#define USB_DEVICE_ID_APPLE_WELLSPRING4A_ISO	0x0243
#define USB_DEVICE_ID_APPLE_WELLSPRING4A_JIS	0x0244
#define USB_DEVICE_ID_APPLE_WELLSPRING5_ANSI	0x0245
#define USB_DEVICE_ID_APPLE_WELLSPRING5_ISO	0x0246
#define USB_DEVICE_ID_APPLE_WELLSPRING5_JIS	0x0247
#define USB_DEVICE_ID_APPLE_ALU_REVB_ANSI	0x024f
#define USB_DEVICE_ID_APPLE_ALU_REVB_ISO	0x0250
#define USB_DEVICE_ID_APPLE_ALU_REVB_JIS	0x0251
#define USB_DEVICE_ID_APPLE_WELLSPRING5A_ANSI	0x0252
#define USB_DEVICE_ID_APPLE_WELLSPRING5A_ISO	0x0253
#define USB_DEVICE_ID_APPLE_WELLSPRING5A_JIS	0x0254
#define USB_DEVICE_ID_APPLE_WELLSPRING7A_ANSI	0x0259
#define USB_DEVICE_ID_APPLE_WELLSPRING7A_ISO	0x025a
#define USB_DEVICE_ID_APPLE_WELLSPRING7A_JIS	0x025b
#define USB_DEVICE_ID_APPLE_WELLSPRING6A_ANSI	0x0249
#define USB_DEVICE_ID_APPLE_WELLSPRING6A_ISO	0x024a
#define USB_DEVICE_ID_APPLE_WELLSPRING6A_JIS	0x024b
#define USB_DEVICE_ID_APPLE_WELLSPRING6_ANSI	0x024c
#define USB_DEVICE_ID_APPLE_WELLSPRING6_ISO	0x024d
#define USB_DEVICE_ID_APPLE_WELLSPRING6_JIS	0x024e
#define USB_DEVICE_ID_APPLE_WELLSPRING7_ANSI	0x0262
#define USB_DEVICE_ID_APPLE_WELLSPRING7_ISO	0x0263
#define USB_DEVICE_ID_APPLE_WELLSPRING7_JIS	0x0264
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2009_ANSI  0x0239
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2009_ISO   0x023a
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2009_JIS   0x023b
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2011_ANSI  0x0255
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2011_ISO   0x0256
#define USB_DEVICE_ID_APPLE_ALU_WIRELESS_2011_JIS   0x0257
#define USB_DEVICE_ID_APPLE_MAGIC_KEYBOARD_2015   0x0267
#define USB_DEVICE_ID_APPLE_MAGIC_KEYBOARD_NUMPAD_2015   0x026c
#define USB_DEVICE_ID_APPLE_WELLSPRING8_ANSI	0x0290
#define USB_DEVICE_ID_APPLE_WELLSPRING8_ISO	0x0291
#define USB_DEVICE_ID_APPLE_WELLSPRING8_JIS	0x0292
#define USB_DEVICE_ID_APPLE_WELLSPRING9_ANSI	0x0272
#define USB_DEVICE_ID_APPLE_WELLSPRING9_ISO		0x0273
#define USB_DEVICE_ID_APPLE_WELLSPRING9_JIS		0x0274
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J140K	0x027a
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J132	0x027b
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J680	0x027c
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J213	0x027d
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J214K	0x027e
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J223	0x027f
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J230K	0x0280
#define USB_DEVICE_ID_APPLE_WELLSPRINGT2_J152F	0x0340
#define USB_DEVICE_ID_APPLE_FOUNTAIN_TP_ONLY	0x030a
#define USB_DEVICE_ID_APPLE_GEYSER1_TP_ONLY	0x030b
#define USB_DEVICE_ID_APPLE_IRCONTROL	0x8240
#define USB_DEVICE_ID_APPLE_IRCONTROL2	0x1440
#define USB_DEVICE_ID_APPLE_IRCONTROL3	0x8241
#define USB_DEVICE_ID_APPLE_IRCONTROL4	0x8242
#define USB_DEVICE_ID_APPLE_IRCONTROL5	0x8243
#define USB_DEVICE_ID_APPLE_MAGIC_KEYBOARD_2021   0x029c
#define USB_DEVICE_ID_APPLE_MAGIC_KEYBOARD_FINGERPRINT_2021   0x029a
#define USB_DEVICE_ID_APPLE_MAGIC_KEYBOARD_NUMPAD_2021   0x029f
#define USB_DEVICE_ID_APPLE_TOUCHBAR_BACKLIGHT 0x8102
#define USB_DEVICE_ID_APPLE_TOUCHBAR_DISPLAY 0x8302

#define USB_VENDOR_ID_ASUS		0x0486
#define USB_DEVICE_ID_ASUS_T91MT	0x0185
#define USB_DEVICE_ID_ASUSTEK_MULTITOUCH_YFO	0x0186

#define USB_VENDOR_ID_ASUSTEK		0x0b05
#define USB_DEVICE_ID_ASUSTEK_LCM	0x1726
#define USB_DEVICE_ID_ASUSTEK_LCM2	0x175b
#define USB_DEVICE_ID_ASUSTEK_T100TA_KEYBOARD	0x17e0
#define USB_DEVICE_ID_ASUSTEK_T100TAF_KEYBOARD	0x1807
#define USB_DEVICE_ID_ASUSTEK_T100CHI_KEYBOARD	0x8502
#define USB_DEVICE_ID_ASUSTEK_T101HA_KEYBOARD	0x183d
#define USB_DEVICE_ID_ASUSTEK_T304_KEYBOARD	0x184a
#define USB_DEVICE_ID_ASUSTEK_I2C_KEYBOARD	0x8585
#define USB_DEVICE_ID_ASUSTEK_I2C_TOUCHPAD	0x0101
#define USB_DEVICE_ID_ASUSTEK_ROG_KEYBOARD1 0x1854
#define USB_DEVICE_ID_ASUSTEK_ROG_KEYBOARD2 0x1837
#define USB_DEVICE_ID_ASUSTEK_ROG_KEYBOARD3 0x1822
#define USB_DEVICE_ID_ASUSTEK_ROG_NKEY_KEYBOARD	0x1866
#define USB_DEVICE_ID_ASUSTEK_ROG_NKEY_KEYBOARD2	0x19b6
#define USB_DEVICE_ID_ASUSTEK_ROG_CLAYMORE_II_KEYBOARD	0x196b
#define USB_DEVICE_ID_ASUSTEK_FX503VD_KEYBOARD	0x1869

#define USB_VENDOR_ID_ATEN		0x0557
#define USB_DEVICE_ID_ATEN_UC100KM	0x2004
#define USB_DEVICE_ID_ATEN_CS124U	0x2202
#define USB_DEVICE_ID_ATEN_2PORTKVM	0x2204
#define USB_DEVICE_ID_ATEN_4PORTKVM	0x2205
#define USB_DEVICE_ID_ATEN_4PORTKVMC	0x2208
#define USB_DEVICE_ID_ATEN_CS682	0x2213
#define USB_DEVICE_ID_ATEN_CS692	0x8021
#define USB_DEVICE_ID_ATEN_CS1758	0x2220

#define USB_VENDOR_ID_ATMEL		0x03eb
#define USB_DEVICE_ID_ATMEL_MULTITOUCH	0x211c
#define USB_DEVICE_ID_ATMEL_MXT_DIGITIZER	0x2118
#define USB_VENDOR_ID_ATMEL_V_USB	0x16c0
#define USB_DEVICE_ID_ATMEL_V_USB	0x05df

#define USB_VENDOR_ID_AUREAL		0x0755
#define USB_DEVICE_ID_AUREAL_W01RN	0x2626

#define USB_VENDOR_ID_AVERMEDIA		0x07ca
#define USB_DEVICE_ID_AVER_FM_MR800	0xb800

#define USB_VENDOR_ID_AXENTIA		0x12cf
#define USB_DEVICE_ID_AXENTIA_FM_RADIO	0x7111

#define USB_VENDOR_ID_BAANTO		0x2453
#define USB_DEVICE_ID_BAANTO_MT_190W2	0x0100

#define USB_VENDOR_ID_BELKIN		0x050d
#define USB_DEVICE_ID_FLIP_KVM		0x3201

#define USB_VENDOR_ID_BERKSHIRE		0x0c98
#define USB_DEVICE_ID_BERKSHIRE_PCWD	0x1140

#define USB_VENDOR_ID_BETOP_2185BFM	0x11c2
#define USB_VENDOR_ID_BETOP_2185PC	0x11c0
#define USB_VENDOR_ID_BETOP_2185V2PC	0x8380
#define USB_VENDOR_ID_BETOP_2185V2BFM	0x20bc

#define USB_VENDOR_ID_BIGBEN	0x146b
#define USB_DEVICE_ID_BIGBEN_PS3OFMINIPAD	0x0902

#define USB_VENDOR_ID_BTC		0x046e
#define USB_DEVICE_ID_BTC_EMPREX_REMOTE	0x5578
#define USB_DEVICE_ID_BTC_EMPREX_REMOTE_2	0x5577

#define USB_VENDOR_ID_CANDO		0x2087
#define USB_DEVICE_ID_CANDO_PIXCIR_MULTI_TOUCH 0x0703
#define USB_DEVICE_ID_CANDO_MULTI_TOUCH	0x0a01
#define USB_DEVICE_ID_CANDO_MULTI_TOUCH_10_1 0x0a02
#define USB_DEVICE_ID_CANDO_MULTI_TOUCH_11_6 0x0b03
#define USB_DEVICE_ID_CANDO_MULTI_TOUCH_15_6 0x0f01

#define USB_VENDOR_ID_CH		0x068e
#define USB_DEVICE_ID_CH_PRO_THROTTLE	0x00f1
#define USB_DEVICE_ID_CH_PRO_PEDALS	0x00f2
#define USB_DEVICE_ID_CH_FIGHTERSTICK	0x00f3
#define USB_DEVICE_ID_CH_COMBATSTICK	0x00f4
#define USB_DEVICE_ID_CH_FLIGHT_SIM_ECLIPSE_YOKE       0x0051
#define USB_DEVICE_ID_CH_FLIGHT_SIM_YOKE	0x00ff
#define USB_DEVICE_ID_CH_3AXIS_5BUTTON_STICK	0x00d3
#define USB_DEVICE_ID_CH_AXIS_295	0x001c

#define USB_VENDOR_ID_CHERRY		0x046a
#define USB_DEVICE_ID_CHERRY_CYMOTION	0x0023
#define USB_DEVICE_ID_CHERRY_CYMOTION_SOLAR	0x0027

#define USB_VENDOR_ID_CHIC		0x05fe
#define USB_DEVICE_ID_CHIC_GAMEPAD	0x0014

#define USB_VENDOR_ID_CHICONY		0x04f2
#define USB_DEVICE_ID_CHICONY_TACTICAL_PAD	0x0418
#define USB_DEVICE_ID_CHICONY_MULTI_TOUCH	0xb19d
#define USB_DEVICE_ID_CHICONY_WIRELESS	0x0618
#define USB_DEVICE_ID_CHICONY_PIXART_USB_OPTICAL_MOUSE	0x1053
#define USB_DEVICE_ID_CHICONY_PIXART_USB_OPTICAL_MOUSE2	0x0939
#define USB_DEVICE_ID_CHICONY_WIRELESS2	0x1123
#define USB_DEVICE_ID_CHICONY_WIRELESS3	0x1236
#define USB_DEVICE_ID_ASUS_AK1D		0x1125
#define USB_DEVICE_ID_CHICONY_TOSHIBA_WT10A	0x1408
#define USB_DEVICE_ID_CHICONY_ACER_SWITCH12	0x1421

#define USB_VENDOR_ID_CHUNGHWAT		0x2247
#define USB_DEVICE_ID_CHUNGHWAT_MULTITOUCH	0x0001

#define USB_VENDOR_ID_CIDC		0x1677

#define USB_VENDOR_ID_CJTOUCH		0x24b8
#define USB_DEVICE_ID_CJTOUCH_MULTI_TOUCH_0020	0x0020
#define USB_DEVICE_ID_CJTOUCH_MULTI_TOUCH_0040	0x0040

#define USB_VENDOR_ID_CLAY_LOGIC	0x20a0
#define USB_DEVICE_ID_NITROKEY_U2F	0x4287

#define USB_VENDOR_ID_CMEDIA		0x0d8c
#define USB_DEVICE_ID_CM109		0x000e
#define USB_DEVICE_ID_CMEDIA_HS100B	0x0014
#define USB_DEVICE_ID_CM6533		0x0022

#define USB_VENDOR_ID_CODEMERCS		0x07c0
#define USB_DEVICE_ID_CODEMERCS_IOW_FIRST	0x1500
#define USB_DEVICE_ID_CODEMERCS_IOW_LAST	0x15ff

#define USB_VENDOR_ID_CORSAIR		0x1b1c
#define USB_DEVICE_ID_CORSAIR_K90	0x1b02
#define USB_DEVICE_ID_CORSAIR_K70R      0x1b09
#define USB_DEVICE_ID_CORSAIR_K95RGB    0x1b11
#define USB_DEVICE_ID_CORSAIR_M65RGB    0x1b12
#define USB_DEVICE_ID_CORSAIR_K70RGB    0x1b13
#define USB_DEVICE_ID_CORSAIR_STRAFE    0x1b15
#define USB_DEVICE_ID_CORSAIR_K65RGB    0x1b17
#define USB_DEVICE_ID_CORSAIR_GLAIVE_RGB        0x1b34
#define USB_DEVICE_ID_CORSAIR_K70RGB_RAPIDFIRE  0x1b38
#define USB_DEVICE_ID_CORSAIR_K65RGB_RAPIDFIRE  0x1b39
#define USB_DEVICE_ID_CORSAIR_SCIMITAR_PRO_RGB  0x1b3e

#define USB_VENDOR_ID_CREATIVELABS	0x041e
#define USB_DEVICE_ID_CREATIVE_SB_OMNI_SURROUND_51	0x322c
#define USB_DEVICE_ID_PRODIKEYS_PCMIDI	0x2801
#define USB_DEVICE_ID_CREATIVE_SB0540	0x3100

#define USB_VENDOR_ID_CVTOUCH		0x1ff7
#define USB_DEVICE_ID_CVTOUCH_SCREEN	0x0013

#define USB_VENDOR_ID_CYGNAL		0x10c4
#define USB_DEVICE_ID_CYGNAL_RADIO_SI470X	0x818a
#define USB_DEVICE_ID_FOCALTECH_FTXXXX_MULTITOUCH	0x81b9
#define USB_DEVICE_ID_CYGNAL_CP2112	0xea90
#define USB_DEVICE_ID_U2F_ZERO		0x8acf

#define USB_DEVICE_ID_CYGNAL_RADIO_SI4713       0x8244

#define USB_VENDOR_ID_CYPRESS		0x04b4
#define USB_DEVICE_ID_CYPRESS_MOUSE	0x0001
#define USB_DEVICE_ID_CYPRESS_HIDCOM	0x5500
#define USB_DEVICE_ID_CYPRESS_ULTRAMOUSE	0x7417
#define USB_DEVICE_ID_CYPRESS_BARCODE_1	0xde61
#define USB_DEVICE_ID_CYPRESS_BARCODE_2	0xde64
#define USB_DEVICE_ID_CYPRESS_BARCODE_3	0xbca1
#define USB_DEVICE_ID_CYPRESS_BARCODE_4	0xed81
#define USB_DEVICE_ID_CYPRESS_TRUETOUCH	0xc001

#define USB_DEVICE_ID_CYPRESS_VARMILO_VA104M_07B1   0X07b1

#define USB_VENDOR_ID_DATA_MODUL	0x7374
#define USB_VENDOR_ID_DATA_MODUL_EASYMAXTOUCH	0x1201

#define USB_VENDOR_ID_DEALEXTREAME	0x10c5
#define USB_DEVICE_ID_DEALEXTREAME_RADIO_SI4701	0x819a

#define USB_VENDOR_ID_DELCOM		0x0fc5
#define USB_DEVICE_ID_DELCOM_VISUAL_IND	0xb080

#define USB_VENDOR_ID_DELL				0x413c
#define USB_DEVICE_ID_DELL_PIXART_USB_OPTICAL_MOUSE	0x301a

#define USB_VENDOR_ID_DELORME		0x1163
#define USB_DEVICE_ID_DELORME_EARTHMATE	0x0100
#define USB_DEVICE_ID_DELORME_EM_LT20	0x0200

#define USB_VENDOR_ID_DMI		0x0c0b
#define USB_DEVICE_ID_DMI_ENC		0x5fab

#define USB_VENDOR_ID_DRAGONRISE		0x0079
#define USB_DEVICE_ID_REDRAGON_SEYMUR2		0x0006
#define USB_DEVICE_ID_DRAGONRISE_WIIU		0x1800
#define USB_DEVICE_ID_DRAGONRISE_PS3		0x1801
#define USB_DEVICE_ID_DRAGONRISE_DOLPHINBAR	0x1803
#define USB_DEVICE_ID_DRAGONRISE_GAMECUBE1	0x1843
#define USB_DEVICE_ID_DRAGONRISE_GAMECUBE2	0x1844
#define USB_DEVICE_ID_DRAGONRISE_GAMECUBE3	0x1846

#define USB_VENDOR_ID_DWAV		0x0eef
#define USB_DEVICE_ID_EGALAX_TOUCHCONTROLLER	0x0001
#define USB_DEVICE_ID_DWAV_TOUCHCONTROLLER	0x0002
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_480D	0x480d
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_480E	0x480e
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_7207	0x7207
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_720C	0x720c
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_7224	0x7224
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_722A	0x722A
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_725E	0x725e
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_7262	0x7262
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_726B	0x726b
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_72A1	0x72a1
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_72AA	0x72aa
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_72C4	0x72c4
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_72D0	0x72d0
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_72FA	0x72fa
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_7302	0x7302
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_7349	0x7349
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_73F7	0x73f7
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_A001	0xa001
#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH_C002	0xc002

#define USB_VENDOR_ID_ELAN		0x04f3
#define USB_DEVICE_ID_TOSHIBA_CLICK_L9W	0x0401
#define USB_DEVICE_ID_HP_X2		0x074d
#define USB_DEVICE_ID_HP_X2_10_COVER	0x0755
#define I2C_DEVICE_ID_HP_ENVY_X360_15	0x2d05
#define I2C_DEVICE_ID_HP_ENVY_X360_15T_DR100	0x29CF
#define I2C_DEVICE_ID_HP_ENVY_X360_EU0009NV	0x2CF9
#define I2C_DEVICE_ID_HP_SPECTRE_X360_15	0x2817
#define I2C_DEVICE_ID_HP_SPECTRE_X360_13_AW0020NG  0x29DF
#define I2C_DEVICE_ID_ASUS_TP420IA_TOUCHSCREEN 0x2BC8
#define I2C_DEVICE_ID_ASUS_GV301RA_TOUCHSCREEN 0x2C82
#define USB_DEVICE_ID_ASUS_UX550VE_TOUCHSCREEN	0x2544
#define USB_DEVICE_ID_ASUS_UX550_TOUCHSCREEN	0x2706
#define I2C_DEVICE_ID_SURFACE_GO_TOUCHSCREEN	0x261A
#define I2C_DEVICE_ID_SURFACE_GO2_TOUCHSCREEN	0x2A1C
#define I2C_DEVICE_ID_LENOVO_YOGA_C630_TOUCHSCREEN	0x279F

#define USB_VENDOR_ID_ELECOM		0x056e
#define USB_DEVICE_ID_ELECOM_BM084	0x0061
#define USB_DEVICE_ID_ELECOM_M_XGL20DLBK	0x00e6
#define USB_DEVICE_ID_ELECOM_M_XT3URBK	0x00fb
#define USB_DEVICE_ID_ELECOM_M_XT3DRBK	0x00fc
#define USB_DEVICE_ID_ELECOM_M_XT4DRBK	0x00fd
#define USB_DEVICE_ID_ELECOM_M_DT1URBK	0x00fe
#define USB_DEVICE_ID_ELECOM_M_DT1DRBK	0x00ff
#define USB_DEVICE_ID_ELECOM_M_HT1URBK	0x010c
#define USB_DEVICE_ID_ELECOM_M_HT1DRBK_010D	0x010d
#define USB_DEVICE_ID_ELECOM_M_HT1DRBK_011C	0x011c

#define USB_VENDOR_ID_DREAM_CHEEKY	0x1d34
#define USB_DEVICE_ID_DREAM_CHEEKY_WN	0x0004
#define USB_DEVICE_ID_DREAM_CHEEKY_FA	0x000a

#define USB_VENDOR_ID_ELITEGROUP	0x03fc
#define USB_DEVICE_ID_ELITEGROUP_05D8	0x05d8

#define USB_VENDOR_ID_ELO		0x04E7
#define USB_DEVICE_ID_ELO_TS2515	0x0022
#define USB_DEVICE_ID_ELO_TS2700	0x0020
#define USB_DEVICE_ID_ELO_ACCUTOUCH_2216	0x0050

#define USB_VENDOR_ID_EMS		0x2006
#define USB_DEVICE_ID_EMS_TRIO_LINKER_PLUS_II 0x0118

#define USB_VENDOR_ID_FLATFROG		0x25b5
#define USB_DEVICE_ID_MULTITOUCH_3200	0x0002

#define USB_VENDOR_ID_FUTABA            0x0547
#define USB_DEVICE_ID_LED_DISPLAY       0x7000

#define USB_VENDOR_ID_FUTURE_TECHNOLOGY	0x0403
#define USB_DEVICE_ID_RETRODE2		0x97c1
#define USB_DEVICE_ID_FT260             0x6030

#define USB_VENDOR_ID_ESSENTIAL_REALITY	0x0d7f
#define USB_DEVICE_ID_ESSENTIAL_REALITY_P5 0x0100

#define USB_VENDOR_ID_ETT		0x0664
#define USB_DEVICE_ID_TC5UH		0x0309
#define USB_DEVICE_ID_TC4UM		0x0306

#define USB_VENDOR_ID_ETURBOTOUCH	0x22b9
#define USB_DEVICE_ID_ETURBOTOUCH	0x0006
#define USB_DEVICE_ID_ETURBOTOUCH_2968	0x2968

#define USB_VENDOR_ID_EZKEY		0x0518
#define USB_DEVICE_ID_BTC_8193		0x0002

#define USB_VENDOR_ID_FORMOSA          0x147a
#define USB_DEVICE_ID_FORMOSA_IR_RECEIVER      0xe03e

#define USB_VENDOR_ID_FREESCALE		0x15A2
#define USB_DEVICE_ID_FREESCALE_MX28	0x004F

#define USB_VENDOR_ID_FRUCTEL	0x25B6
#define USB_DEVICE_ID_GAMETEL_MT_MODE	0x0002

#define USB_VENDOR_ID_GAMEVICE	0x27F8
#define USB_DEVICE_ID_GAMEVICE_GV186	0x0BBE
#define USB_DEVICE_ID_GAMEVICE_KISHI	0x0BBF

#define USB_VENDOR_ID_GAMERON		0x0810
#define USB_DEVICE_ID_GAMERON_DUAL_PSX_ADAPTOR	0x0001
#define USB_DEVICE_ID_GAMERON_DUAL_PCS_ADAPTOR	0x0002

#define USB_VENDOR_ID_GEMBIRD			0x11ff
#define USB_DEVICE_ID_GEMBIRD_JPD_DUALFORCE2	0x3331

#define USB_VENDOR_ID_GENERAL_TOUCH	0x0dfc
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN7_TWOFINGERS 0x0003
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PWT_TENFINGERS 0x0100
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PIT_0101 0x0101
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PIT_0102 0x0102
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PIT_0106 0x0106
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PIT_010A 0x010a
#define USB_DEVICE_ID_GENERAL_TOUCH_WIN8_PIT_E100 0xe100

#define USB_VENDOR_ID_GLORIOUS  0x258a
#define USB_DEVICE_ID_GLORIOUS_MODEL_D 0x0033
#define USB_DEVICE_ID_GLORIOUS_MODEL_O 0x0036

#define I2C_VENDOR_ID_GOODIX		0x27c6
#define I2C_DEVICE_ID_GOODIX_01F0	0x01f0

#define USB_VENDOR_ID_GOODTOUCH		0x1aad
#define USB_DEVICE_ID_GOODTOUCH_000f	0x000f

#define USB_VENDOR_ID_GOOGLE		0x18d1
#define USB_DEVICE_ID_GOOGLE_HAMMER	0x5022
#define USB_DEVICE_ID_GOOGLE_TOUCH_ROSE	0x5028
#define USB_DEVICE_ID_GOOGLE_STAFF	0x502b
#define USB_DEVICE_ID_GOOGLE_WAND	0x502d
#define USB_DEVICE_ID_GOOGLE_WHISKERS	0x5030
#define USB_DEVICE_ID_GOOGLE_MASTERBALL	0x503c
#define USB_DEVICE_ID_GOOGLE_MAGNEMITE	0x503d
#define USB_DEVICE_ID_GOOGLE_MOONBALL	0x5044
#define USB_DEVICE_ID_GOOGLE_DON	0x5050
#define USB_DEVICE_ID_GOOGLE_EEL	0x5057
#define USB_DEVICE_ID_GOOGLE_JEWEL	0x5061

#define USB_VENDOR_ID_GOTOP		0x08f2
#define USB_DEVICE_ID_SUPER_Q2		0x007f
#define USB_DEVICE_ID_GOGOPEN		0x00ce
#define USB_DEVICE_ID_PENPOWER		0x00f4

#define USB_VENDOR_ID_GREENASIA		0x0e8f
#define USB_DEVICE_ID_GREENASIA_DUAL_SAT_ADAPTOR 0x3010
#define USB_DEVICE_ID_GREENASIA_DUAL_USB_JOYPAD	0x3013

#define USB_VENDOR_ID_GRETAGMACBETH	0x0971
#define USB_DEVICE_ID_GRETAGMACBETH_HUEY	0x2005

#define USB_VENDOR_ID_GRIFFIN		0x077d
#define USB_DEVICE_ID_POWERMATE		0x0410
#define USB_DEVICE_ID_SOUNDKNOB		0x04AA
#define USB_DEVICE_ID_RADIOSHARK	0x627a

#define USB_VENDOR_ID_GTCO		0x078c
#define USB_DEVICE_ID_GTCO_90		0x0090
#define USB_DEVICE_ID_GTCO_100		0x0100
#define USB_DEVICE_ID_GTCO_101		0x0101
#define USB_DEVICE_ID_GTCO_103		0x0103
#define USB_DEVICE_ID_GTCO_104		0x0104
#define USB_DEVICE_ID_GTCO_105		0x0105
#define USB_DEVICE_ID_GTCO_106		0x0106
#define USB_DEVICE_ID_GTCO_107		0x0107
#define USB_DEVICE_ID_GTCO_108		0x0108
#define USB_DEVICE_ID_GTCO_200		0x0200
#define USB_DEVICE_ID_GTCO_201		0x0201
#define USB_DEVICE_ID_GTCO_202		0x0202
#define USB_DEVICE_ID_GTCO_203		0x0203
#define USB_DEVICE_ID_GTCO_204		0x0204
#define USB_DEVICE_ID_GTCO_205		0x0205
#define USB_DEVICE_ID_GTCO_206		0x0206
#define USB_DEVICE_ID_GTCO_207		0x0207
#define USB_DEVICE_ID_GTCO_300		0x0300
#define USB_DEVICE_ID_GTCO_301		0x0301
#define USB_DEVICE_ID_GTCO_302		0x0302
#define USB_DEVICE_ID_GTCO_303		0x0303
#define USB_DEVICE_ID_GTCO_304		0x0304
#define USB_DEVICE_ID_GTCO_305		0x0305
#define USB_DEVICE_ID_GTCO_306		0x0306
#define USB_DEVICE_ID_GTCO_307		0x0307
#define USB_DEVICE_ID_GTCO_308		0x0308
#define USB_DEVICE_ID_GTCO_309		0x0309
#define USB_DEVICE_ID_GTCO_400		0x0400
#define USB_DEVICE_ID_GTCO_401		0x0401
#define USB_DEVICE_ID_GTCO_402		0x0402
#define USB_DEVICE_ID_GTCO_403		0x0403
#define USB_DEVICE_ID_GTCO_404		0x0404
#define USB_DEVICE_ID_GTCO_405		0x0405
#define USB_DEVICE_ID_GTCO_500		0x0500
#define USB_DEVICE_ID_GTCO_501		0x0501
#define USB_DEVICE_ID_GTCO_502		0x0502
#define USB_DEVICE_ID_GTCO_503		0x0503
#define USB_DEVICE_ID_GTCO_504		0x0504
#define USB_DEVICE_ID_GTCO_1000		0x1000
#define USB_DEVICE_ID_GTCO_1001		0x1001
#define USB_DEVICE_ID_GTCO_1002		0x1002
#define USB_DEVICE_ID_GTCO_1003		0x1003
#define USB_DEVICE_ID_GTCO_1004		0x1004
#define USB_DEVICE_ID_GTCO_1005		0x1005
#define USB_DEVICE_ID_GTCO_1006		0x1006
#define USB_DEVICE_ID_GTCO_1007		0x1007

#define USB_VENDOR_ID_GYRATION		0x0c16
#define USB_DEVICE_ID_GYRATION_REMOTE	0x0002
#define USB_DEVICE_ID_GYRATION_REMOTE_2 0x0003
#define USB_DEVICE_ID_GYRATION_REMOTE_3 0x0008

#define I2C_VENDOR_ID_HANTICK		0x0911
#define I2C_PRODUCT_ID_HANTICK_5288	0x5288

#define USB_VENDOR_ID_HANWANG		0x0b57
#define USB_DEVICE_ID_HANWANG_TABLET_FIRST	0x5000
#define USB_DEVICE_ID_HANWANG_TABLET_LAST	0x8fff

#define USB_VENDOR_ID_HANVON		0x20b3
#define USB_DEVICE_ID_HANVON_MULTITOUCH	0x0a18

#define USB_VENDOR_ID_HANVON_ALT	0x22ed
#define USB_DEVICE_ID_HANVON_ALT_MULTITOUCH	0x1010

#define USB_VENDOR_ID_HAPP		0x078b
#define USB_DEVICE_ID_UGCI_DRIVING	0x0010
#define USB_DEVICE_ID_UGCI_FLYING	0x0020
#define USB_DEVICE_ID_UGCI_FIGHTING	0x0030

#define USB_VENDOR_ID_HP		0x03f0
#define USB_PRODUCT_ID_HP_ELITE_PRESENTER_MOUSE_464A		0x464a
#define USB_PRODUCT_ID_HP_LOGITECH_OEM_USB_OPTICAL_MOUSE_0A4A	0x0a4a
#define USB_PRODUCT_ID_HP_LOGITECH_OEM_USB_OPTICAL_MOUSE_0B4A	0x0b4a
#define USB_PRODUCT_ID_HP_PIXART_OEM_USB_OPTICAL_MOUSE		0x134a
#define USB_PRODUCT_ID_HP_PIXART_OEM_USB_OPTICAL_MOUSE_094A	0x094a
#define USB_PRODUCT_ID_HP_PIXART_OEM_USB_OPTICAL_MOUSE_0941	0x0941
#define USB_PRODUCT_ID_HP_PIXART_OEM_USB_OPTICAL_MOUSE_0641	0x0641
#define USB_PRODUCT_ID_HP_PIXART_OEM_USB_OPTICAL_MOUSE_1f4a	0x1f4a

#define USB_VENDOR_ID_HUION		0x256c
#define USB_DEVICE_ID_HUION_TABLET	0x006e
#define USB_DEVICE_ID_HUION_TABLET2	0x006d

#define USB_VENDOR_ID_IBM					0x04b3
#define USB_DEVICE_ID_IBM_SCROLLPOINT_III			0x3100
#define USB_DEVICE_ID_IBM_SCROLLPOINT_PRO			0x3103
#define USB_DEVICE_ID_IBM_SCROLLPOINT_OPTICAL			0x3105
#define USB_DEVICE_ID_IBM_SCROLLPOINT_800DPI_OPTICAL		0x3108
#define USB_DEVICE_ID_IBM_SCROLLPOINT_800DPI_OPTICAL_PRO	0x3109

#define USB_VENDOR_ID_IDEACOM		0x1cb6
#define USB_DEVICE_ID_IDEACOM_IDC6650	0x6650
#define USB_DEVICE_ID_IDEACOM_IDC6651	0x6651
#define USB_DEVICE_ID_IDEACOM_IDC6680	0x6680

#define USB_VENDOR_ID_ILITEK		0x222a
#define USB_DEVICE_ID_ILITEK_MULTITOUCH	0x0001

#define USB_VENDOR_ID_INTEL_0		0x8086
#define USB_VENDOR_ID_INTEL_1		0x8087
#define USB_DEVICE_ID_INTEL_HID_SENSOR_0	0x09fa
#define USB_DEVICE_ID_INTEL_HID_SENSOR_1	0x0a04

#define USB_VENDOR_ID_STM_0             0x0483
#define USB_DEVICE_ID_STM_HID_SENSOR    0x91d1
#define USB_DEVICE_ID_STM_HID_SENSOR_1  0x9100

#define USB_VENDOR_ID_ION		0x15e4
#define USB_DEVICE_ID_ICADE		0x0132

#define USB_VENDOR_ID_HOLTEK		0x1241
#define USB_DEVICE_ID_HOLTEK_ON_LINE_GRIP	0x5015

#define USB_VENDOR_ID_HOLTEK_ALT		0x04d9
#define USB_DEVICE_ID_HOLTEK_ALT_KEYBOARD	0xa055
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A04A	0xa04a
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A067	0xa067
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A070	0xa070
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A072	0xa072
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A081	0xa081
#define USB_DEVICE_ID_HOLTEK_ALT_MOUSE_A0C2	0xa0c2
#define USB_DEVICE_ID_HOLTEK_ALT_KEYBOARD_A096	0xa096
#define USB_DEVICE_ID_HOLTEK_ALT_KEYBOARD_A293	0xa293

#define USB_VENDOR_ID_IMATION		0x0718
#define USB_DEVICE_ID_DISC_STAKKA	0xd000

#define USB_VENDOR_ID_IRTOUCHSYSTEMS	0x6615
#define USB_DEVICE_ID_IRTOUCH_INFRARED_USB	0x0070

#define USB_VENDOR_ID_INNOMEDIA			0x1292
#define USB_DEVICE_ID_INNEX_GENESIS_ATARI	0x4745

#define USB_VENDOR_ID_ITE               0x048d
#define I2C_VENDOR_ID_ITE		0x103c
#define I2C_DEVICE_ID_ITE_VOYO_WINPAD_A15	0x184f
#define USB_DEVICE_ID_ITE_LENOVO_YOGA   0x8386
#define USB_DEVICE_ID_ITE_LENOVO_YOGA2  0x8350
#define I2C_DEVICE_ID_ITE_LENOVO_LEGION_Y720	0x837a
#define USB_DEVICE_ID_ITE_LENOVO_YOGA900	0x8396
#define USB_DEVICE_ID_ITE8595		0x8595
#define USB_DEVICE_ID_ITE_MEDION_E1239T	0xce50

#define USB_VENDOR_ID_JABRA		0x0b0e
#define USB_DEVICE_ID_JABRA_SPEAK_410	0x0412
#define USB_DEVICE_ID_JABRA_SPEAK_510	0x0420
#define USB_DEVICE_ID_JABRA_GN9350E	0x9350

#define USB_VENDOR_ID_JESS		0x0c45
#define USB_DEVICE_ID_JESS_YUREX	0x1010
#define USB_DEVICE_ID_ASUS_MD_5112	0x5112
#define USB_DEVICE_ID_REDRAGON_ASURA	0x760b

#define USB_VENDOR_ID_JESS2		0x0f30
#define USB_DEVICE_ID_JESS2_COLOR_RUMBLE_PAD 0x0111

#define USB_VENDOR_ID_KBGEAR		0x084e
#define USB_DEVICE_ID_KBGEAR_JAMSTUDIO	0x1001

#define USB_VENDOR_ID_KENSINGTON	0x047d
#define USB_DEVICE_ID_KS_SLIMBLADE	0x2041

#define USB_VENDOR_ID_KWORLD		0x1b80
#define USB_DEVICE_ID_KWORLD_RADIO_FM700	0xd700

#define USB_VENDOR_ID_KEYTOUCH		0x0926
#define USB_DEVICE_ID_KEYTOUCH_IEC	0x3333

#define USB_VENDOR_ID_KYE		0x0458
#define USB_DEVICE_ID_KYE_ERGO_525V	0x0087
#define USB_DEVICE_ID_GENIUS_GILA_GAMING_MOUSE	0x0138
#define USB_DEVICE_ID_GENIUS_MANTICORE	0x0153
#define USB_DEVICE_ID_GENIUS_GX_IMPERATOR	0x4018
#define USB_DEVICE_ID_KYE_GPEN_560	0x5003
#define USB_DEVICE_ID_KYE_EASYPEN_I405X	0x5010
#define USB_DEVICE_ID_KYE_MOUSEPEN_I608X	0x5011
#define USB_DEVICE_ID_KYE_MOUSEPEN_I608X_V2	0x501a
#define USB_DEVICE_ID_KYE_EASYPEN_M610X	0x5013
#define USB_DEVICE_ID_KYE_PENSKETCH_M912	0x5015
#define USB_DEVICE_ID_KYE_EASYPEN_M406XE	0x5019

#define USB_VENDOR_ID_LABTEC		0x1020
#define USB_DEVICE_ID_LABTEC_WIRELESS_KEYBOARD	0x0006

#define USB_VENDOR_ID_LCPOWER		0x1241
#define USB_DEVICE_ID_LCPOWER_LC1000	0xf767

#define USB_VENDOR_ID_LD		0x0f11
#define USB_DEVICE_ID_LD_CASSY		0x1000
#define USB_DEVICE_ID_LD_CASSY2		0x1001
#define USB_DEVICE_ID_LD_POCKETCASSY	0x1010
#define USB_DEVICE_ID_LD_POCKETCASSY2	0x1011
#define USB_DEVICE_ID_LD_MOBILECASSY	0x1020
#define USB_DEVICE_ID_LD_MOBILECASSY2	0x1021
#define USB_DEVICE_ID_LD_MICROCASSYVOLTAGE	0x1031
#define USB_DEVICE_ID_LD_MICROCASSYCURRENT	0x1032
#define USB_DEVICE_ID_LD_MICROCASSYTIME		0x1033
#define USB_DEVICE_ID_LD_MICROCASSYTEMPERATURE	0x1035
#define USB_DEVICE_ID_LD_MICROCASSYPH		0x1038
#define USB_DEVICE_ID_LD_POWERANALYSERCASSY	0x1040
#define USB_DEVICE_ID_LD_CONVERTERCONTROLLERCASSY	0x1042
#define USB_DEVICE_ID_LD_MACHINETESTCASSY	0x1043
#define USB_DEVICE_ID_LD_JWM		0x1080
#define USB_DEVICE_ID_LD_DMMP		0x1081
#define USB_DEVICE_ID_LD_UMIP		0x1090
#define USB_DEVICE_ID_LD_UMIC		0x10A0
#define USB_DEVICE_ID_LD_UMIB		0x10B0
#define USB_DEVICE_ID_LD_XRAY		0x1100
#define USB_DEVICE_ID_LD_XRAY2		0x1101
#define USB_DEVICE_ID_LD_XRAYCT		0x1110
#define USB_DEVICE_ID_LD_VIDEOCOM	0x1200
#define USB_DEVICE_ID_LD_MOTOR		0x1210
#define USB_DEVICE_ID_LD_COM3LAB	0x2000
#define USB_DEVICE_ID_LD_TELEPORT	0x2010
#define USB_DEVICE_ID_LD_NETWORKANALYSER 0x2020
#define USB_DEVICE_ID_LD_POWERCONTROL	0x2030
#define USB_DEVICE_ID_LD_MACHINETEST	0x2040
#define USB_DEVICE_ID_LD_MOSTANALYSER	0x2050
#define USB_DEVICE_ID_LD_MOSTANALYSER2	0x2051
#define USB_DEVICE_ID_LD_ABSESP		0x2060
#define USB_DEVICE_ID_LD_AUTODATABUS	0x2070
#define USB_DEVICE_ID_LD_MCT		0x2080
#define USB_DEVICE_ID_LD_HYBRID		0x2090
#define USB_DEVICE_ID_LD_HEATCONTROL	0x20A0

#define USB_VENDOR_ID_LENOVO		0x17ef
#define USB_DEVICE_ID_LENOVO_TPKBD	0x6009
#define USB_DEVICE_ID_LENOVO_CUSBKBD	0x6047
#define USB_DEVICE_ID_LENOVO_TPIIUSBKBD	0x60ee
#define USB_DEVICE_ID_LENOVO_CBTKBD	0x6048
#define USB_DEVICE_ID_LENOVO_TPIIBTKBD	0x60e1
#define USB_DEVICE_ID_LENOVO_SCROLLPOINT_OPTICAL	0x6049
#define USB_DEVICE_ID_LENOVO_TP10UBKBD	0x6062
#define USB_DEVICE_ID_LENOVO_TPPRODOCK	0x6067
#define USB_DEVICE_ID_LENOVO_X1_COVER	0x6085
#define USB_DEVICE_ID_LENOVO_X1_TAB	0x60a3
#define USB_DEVICE_ID_LENOVO_X1_TAB3	0x60b5
#define USB_DEVICE_ID_LENOVO_X12_TAB	0x60fe
#define USB_DEVICE_ID_LENOVO_OPTICAL_USB_MOUSE_600E	0x600e
#define USB_DEVICE_ID_LENOVO_PIXART_USB_MOUSE_608D	0x608d
#define USB_DEVICE_ID_LENOVO_PIXART_USB_MOUSE_6019	0x6019
#define USB_DEVICE_ID_LENOVO_PIXART_USB_MOUSE_602E	0x602e
#define USB_DEVICE_ID_LENOVO_PIXART_USB_MOUSE_6093	0x6093

#define USB_VENDOR_ID_LETSKETCH		0x6161
#define USB_DEVICE_ID_WP9620N		0x4d15

#define USB_VENDOR_ID_LG		0x1fd2
#define USB_DEVICE_ID_LG_MULTITOUCH	0x0064
#define USB_DEVICE_ID_LG_MELFAS_MT	0x6007
#define I2C_DEVICE_ID_LG_8001		0x8001
#define I2C_DEVICE_ID_LG_7010		0x7010

#define USB_VENDOR_ID_LOGITECH		0x046d
#define USB_DEVICE_ID_LOGITECH_Z_10_SPK	0x0a07
#define USB_DEVICE_ID_LOGITECH_AUDIOHUB 0x0a0e
#define USB_DEVICE_ID_LOGITECH_T651	0xb00c
#define USB_DEVICE_ID_LOGITECH_DINOVO_EDGE_KBD	0xb309
#define USB_DEVICE_ID_LOGITECH_C007	0xc007
#define USB_DEVICE_ID_LOGITECH_C077	0xc077
#define USB_DEVICE_ID_LOGITECH_RECEIVER	0xc101
#define USB_DEVICE_ID_LOGITECH_HARMONY_FIRST  0xc110
#define USB_DEVICE_ID_LOGITECH_HARMONY_LAST 0xc14f
#define USB_DEVICE_ID_LOGITECH_HARMONY_PS3 0x0306
#define USB_DEVICE_ID_LOGITECH_KEYBOARD_G710_PLUS 0xc24d
#define USB_DEVICE_ID_LOGITECH_MOUSE_C01A	0xc01a
#define USB_DEVICE_ID_LOGITECH_MOUSE_C05A	0xc05a
#define USB_DEVICE_ID_LOGITECH_MOUSE_C06A	0xc06a
#define USB_DEVICE_ID_LOGITECH_RUMBLEPAD_CORD	0xc20a
#define USB_DEVICE_ID_LOGITECH_RUMBLEPAD	0xc211
#define USB_DEVICE_ID_LOGITECH_EXTREME_3D	0xc215
#define USB_DEVICE_ID_LOGITECH_DUAL_ACTION	0xc216
#define USB_DEVICE_ID_LOGITECH_RUMBLEPAD2	0xc218
#define USB_DEVICE_ID_LOGITECH_RUMBLEPAD2_2	0xc219
#define USB_DEVICE_ID_LOGITECH_G15_LCD		0xc222
#define USB_DEVICE_ID_LOGITECH_G11		0xc225
#define USB_DEVICE_ID_LOGITECH_G15_V2_LCD	0xc227
#define USB_DEVICE_ID_LOGITECH_G510		0xc22d
#define USB_DEVICE_ID_LOGITECH_G510_USB_AUDIO	0xc22e
#define USB_DEVICE_ID_LOGITECH_G29_WHEEL	0xc24f
#define USB_DEVICE_ID_LOGITECH_G920_WHEEL	0xc262
#define USB_DEVICE_ID_LOGITECH_WINGMAN_F3D	0xc283
#define USB_DEVICE_ID_LOGITECH_FORCE3D_PRO	0xc286
#define USB_DEVICE_ID_LOGITECH_FLIGHT_SYSTEM_G940	0xc287
#define USB_DEVICE_ID_LOGITECH_WINGMAN_FG	0xc20e
#define USB_DEVICE_ID_LOGITECH_WINGMAN_FFG	0xc293
#define USB_DEVICE_ID_LOGITECH_WHEEL	0xc294
#define USB_DEVICE_ID_LOGITECH_MOMO_WHEEL	0xc295
#define USB_DEVICE_ID_LOGITECH_DFP_WHEEL	0xc298
#define USB_DEVICE_ID_LOGITECH_G25_WHEEL	0xc299
#define USB_DEVICE_ID_LOGITECH_DFGT_WHEEL	0xc29a
#define USB_DEVICE_ID_LOGITECH_G27_WHEEL	0xc29b
#define USB_DEVICE_ID_LOGITECH_WII_WHEEL	0xc29c
#define USB_DEVICE_ID_LOGITECH_ELITE_KBD	0xc30a
#define USB_DEVICE_ID_LOGITECH_GROUP_AUDIO	0x0882
#define USB_DEVICE_ID_S510_RECEIVER	0xc50c
#define USB_DEVICE_ID_S510_RECEIVER_2	0xc517
#define USB_DEVICE_ID_LOGITECH_CORDLESS_DESKTOP_LX500	0xc512
#define USB_DEVICE_ID_MX3000_RECEIVER	0xc513
#define USB_DEVICE_ID_LOGITECH_27MHZ_MOUSE_RECEIVER	0xc51b
#define USB_DEVICE_ID_LOGITECH_UNIFYING_RECEIVER	0xc52b
#define USB_DEVICE_ID_LOGITECH_NANO_RECEIVER		0xc52f
#define USB_DEVICE_ID_LOGITECH_G700_RECEIVER		0xc531
#define USB_DEVICE_ID_LOGITECH_UNIFYING_RECEIVER_2	0xc532
#define USB_DEVICE_ID_LOGITECH_NANO_RECEIVER_2		0xc534
#define USB_DEVICE_ID_LOGITECH_NANO_RECEIVER_LIGHTSPEED_1	0xc539
#define USB_DEVICE_ID_LOGITECH_NANO_RECEIVER_LIGHTSPEED_1_1	0xc53f
#define USB_DEVICE_ID_LOGITECH_NANO_RECEIVER_POWERPLAY	0xc53a
#define USB_DEVICE_ID_SPACETRAVELLER	0xc623
#define USB_DEVICE_ID_SPACENAVIGATOR	0xc626
#define USB_DEVICE_ID_DINOVO_DESKTOP	0xc704
#define USB_DEVICE_ID_MX5000_RECEIVER_MOUSE_DEV		0xc70a
#define USB_DEVICE_ID_MX5000_RECEIVER_KBD_DEV		0xc70e
#define USB_DEVICE_ID_DINOVO_EDGE_RECEIVER_KBD_DEV	0xc713
#define USB_DEVICE_ID_DINOVO_EDGE_RECEIVER_MOUSE_DEV	0xc714
#define USB_DEVICE_ID_MX5500_RECEIVER_KBD_DEV		0xc71b
#define USB_DEVICE_ID_MX5500_RECEIVER_MOUSE_DEV		0xc71c
#define USB_DEVICE_ID_DINOVO_MINI_RECEIVER_KBD_DEV	0xc71e
#define USB_DEVICE_ID_DINOVO_MINI_RECEIVER_MOUSE_DEV	0xc71f
#define USB_DEVICE_ID_LOGITECH_MOMO_WHEEL2	0xca03
#define USB_DEVICE_ID_LOGITECH_VIBRATION_WHEEL	0xca04

#define USB_VENDOR_ID_LUMIO		0x202e
#define USB_DEVICE_ID_CRYSTALTOUCH	0x0006
#define USB_DEVICE_ID_CRYSTALTOUCH_DUAL	0x0007

#define USB_VENDOR_ID_MADCATZ		0x0738
#define USB_DEVICE_ID_MADCATZ_BEATPAD	0x4540
#define USB_DEVICE_ID_MADCATZ_RAT5	0x1705
#define USB_DEVICE_ID_MADCATZ_RAT9	0x1709
#define USB_DEVICE_ID_MADCATZ_MMO7  0x1713

#define USB_VENDOR_ID_MCC		0x09db
#define USB_DEVICE_ID_MCC_PMD1024LS	0x0076
#define USB_DEVICE_ID_MCC_PMD1208LS	0x007a

#define USB_VENDOR_ID_MCS		0x16d0
#define USB_DEVICE_ID_MCS_GAMEPADBLOCK	0x0bcc

#define USB_VENDOR_MEGAWORLD		0x07b5
#define USB_DEVICE_ID_MEGAWORLD_GAMEPAD	0x0312

#define USB_VENDOR_ID_MGE		0x0463
#define USB_DEVICE_ID_MGE_UPS		0xffff
#define USB_DEVICE_ID_MGE_UPS1		0x0001

#define USB_VENDOR_ID_MICROCHIP		0x04d8
#define USB_DEVICE_ID_PICKIT1		0x0032
#define USB_DEVICE_ID_PICKIT2		0x0033
#define USB_DEVICE_ID_PICOLCD		0xc002
#define USB_DEVICE_ID_PICOLCD_BOOTLOADER	0xf002
#define USB_DEVICE_ID_PICK16F1454	0x0042
#define USB_DEVICE_ID_PICK16F1454_V2	0xf2f7
#define USB_DEVICE_ID_LUXAFOR		0xf372
#define USB_DEVICE_ID_MCP2221		0x00dd

#define USB_VENDOR_ID_MICROSOFT		0x045e
#define USB_DEVICE_ID_SIDEWINDER_GV	0x003b
#define USB_DEVICE_ID_MS_OFFICE_KB	0x0048
#define USB_DEVICE_ID_WIRELESS_OPTICAL_DESKTOP_3_0 0x009d
#define USB_DEVICE_ID_MS_DIGITAL_MEDIA_7K 0x00b4
#define USB_DEVICE_ID_MS_NE4K		0x00db
#define USB_DEVICE_ID_MS_NE4K_JP	0x00dc
#define USB_DEVICE_ID_MS_LK6K		0x00f9
#define USB_DEVICE_ID_MS_PRESENTER_8K_BT	0x0701
#define USB_DEVICE_ID_MS_PRESENTER_8K_USB	0x0713
#define USB_DEVICE_ID_MS_NE7K		0x071d
#define USB_DEVICE_ID_MS_DIGITAL_MEDIA_3K	0x0730
#define USB_DEVICE_ID_MS_DIGITAL_MEDIA_3KV1 0x0732
#define USB_DEVICE_ID_MS_DIGITAL_MEDIA_600  0x0750
#define USB_DEVICE_ID_MS_COMFORT_MOUSE_4500	0x076c
#define USB_DEVICE_ID_MS_COMFORT_KEYBOARD 0x00e3
#define USB_DEVICE_ID_MS_SURFACE_PRO_2   0x0799
#define USB_DEVICE_ID_MS_TOUCH_COVER_2   0x07a7
#define USB_DEVICE_ID_MS_TYPE_COVER_2    0x07a9
#define USB_DEVICE_ID_MS_POWER_COVER     0x07da
#define USB_DEVICE_ID_MS_SURFACE3_COVER		0x07de
#define USB_DEVICE_ID_MS_XBOX_ONE_S_CONTROLLER	0x02fd
#define USB_DEVICE_ID_MS_PIXART_MOUSE    0x00cb
#define USB_DEVICE_ID_8BITDO_SN30_PRO_PLUS      0x02e0
#define USB_DEVICE_ID_MS_MOUSE_0783      0x0783

#define USB_VENDOR_ID_MOJO		0x8282
#define USB_DEVICE_ID_RETRO_ADAPTER	0x3201

#define USB_VENDOR_ID_MONTEREY		0x0566
#define USB_DEVICE_ID_GENIUS_KB29E	0x3004

#define USB_VENDOR_ID_MSI		0x1770
#define USB_DEVICE_ID_MSI_GT683R_LED_PANEL 0xff00

#define USB_VENDOR_ID_NATIONAL_SEMICONDUCTOR 0x0400
#define USB_DEVICE_ID_N_S_HARMONY	0xc359

#define USB_VENDOR_ID_NATSU		0x08b7
#define USB_DEVICE_ID_NATSU_GAMEPAD	0x0001

#define USB_VENDOR_ID_NCR		0x0404
#define USB_DEVICE_ID_NCR_FIRST		0x0300
#define USB_DEVICE_ID_NCR_LAST		0x03ff

#define USB_VENDOR_ID_NEC		0x073e
#define USB_DEVICE_ID_NEC_USB_GAME_PAD	0x0301

#define USB_VENDOR_ID_NEXIO		0x1870
#define USB_DEVICE_ID_NEXIO_MULTITOUCH_420	0x010d
#define USB_DEVICE_ID_NEXIO_MULTITOUCH_PTI0750	0x0110

#define USB_VENDOR_ID_NEXTWINDOW	0x1926
#define USB_DEVICE_ID_NEXTWINDOW_TOUCHSCREEN	0x0003

#define USB_VENDOR_ID_NINTENDO		0x057e
#define USB_DEVICE_ID_NINTENDO_WIIMOTE	0x0306
#define USB_DEVICE_ID_NINTENDO_WIIMOTE2	0x0330
#define USB_DEVICE_ID_NINTENDO_JOYCONL	0x2006
#define USB_DEVICE_ID_NINTENDO_JOYCONR	0x2007
#define USB_DEVICE_ID_NINTENDO_PROCON	0x2009
#define USB_DEVICE_ID_NINTENDO_CHRGGRIP	0x200E

#define USB_VENDOR_ID_NOVATEK		0x0603
#define USB_DEVICE_ID_NOVATEK_PCT	0x0600
#define USB_DEVICE_ID_NOVATEK_MOUSE	0x1602

#define USB_VENDOR_ID_NTI               0x0757
#define USB_DEVICE_ID_USB_SUN           0x0a00

#define USB_VENDOR_ID_NTRIG		0x1b96
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN   0x0001
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_1   0x0003
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_2   0x0004
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_3   0x0005
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_4   0x0006
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_5   0x0007
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_6   0x0008
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_7   0x0009
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_8   0x000A
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_9   0x000B
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_10   0x000C
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_11   0x000D
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_12   0x000E
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_13   0x000F
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_14   0x0010
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_15   0x0011
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_16   0x0012
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_17   0x0013
#define USB_DEVICE_ID_NTRIG_TOUCH_SCREEN_18   0x0014
#define USB_DEVICE_ID_NTRIG_DUOSENSE 0x1500

#define USB_VENDOR_ID_ONTRAK		0x0a07
#define USB_DEVICE_ID_ONTRAK_ADU100	0x0064

#define USB_VENDOR_ID_ORTEK		0x05a4
#define USB_DEVICE_ID_ORTEK_PKB1700	0x1700
#define USB_DEVICE_ID_ORTEK_WKB2000	0x2000
#define USB_DEVICE_ID_ORTEK_IHOME_IMAC_A210S	0x8003

#define USB_VENDOR_ID_PLANTRONICS	0x047f
#define USB_DEVICE_ID_PLANTRONICS_BLACKWIRE_3210_SERIES	0xc055
#define USB_DEVICE_ID_PLANTRONICS_BLACKWIRE_3220_SERIES	0xc056
#define USB_DEVICE_ID_PLANTRONICS_BLACKWIRE_3215_SERIES	0xc057
#define USB_DEVICE_ID_PLANTRONICS_BLACKWIRE_3225_SERIES	0xc058

#define USB_VENDOR_ID_PANASONIC		0x04da
#define USB_DEVICE_ID_PANABOARD_UBT780	0x1044
#define USB_DEVICE_ID_PANABOARD_UBT880	0x104d

#define USB_VENDOR_ID_PANJIT		0x134c

#define USB_VENDOR_ID_PANTHERLORD	0x0810
#define USB_DEVICE_ID_PANTHERLORD_TWIN_USB_JOYSTICK	0x0001

#define USB_VENDOR_ID_PENMOUNT		0x14e1
#define USB_DEVICE_ID_PENMOUNT_PCI	0x3500
#define USB_DEVICE_ID_PENMOUNT_1610	0x1610
#define USB_DEVICE_ID_PENMOUNT_1640	0x1640
#define USB_DEVICE_ID_PENMOUNT_6000	0x6000

#define USB_VENDOR_ID_PETALYNX		0x18b1
#define USB_DEVICE_ID_PETALYNX_MAXTER_REMOTE	0x0037

#define USB_VENDOR_ID_PETZL		0x2122
#define USB_DEVICE_ID_PETZL_HEADLAMP	0x1234

#define USB_VENDOR_ID_PHILIPS		0x0471
#define USB_DEVICE_ID_PHILIPS_IEEE802154_DONGLE 0x0617

#define USB_VENDOR_ID_PI_ENGINEERING	0x05f3
#define USB_DEVICE_ID_PI_ENGINEERING_VEC_USB_FOOTPEDAL	0xff

#define USB_VENDOR_ID_PIXART				0x093a
#define USB_DEVICE_ID_PIXART_USB_OPTICAL_MOUSE_ID2	0x0137
#define USB_DEVICE_ID_PIXART_USB_OPTICAL_MOUSE		0x2510
#define USB_DEVICE_ID_PIXART_OPTICAL_TOUCH_SCREEN	0x8001
#define USB_DEVICE_ID_PIXART_OPTICAL_TOUCH_SCREEN1	0x8002
#define USB_DEVICE_ID_PIXART_OPTICAL_TOUCH_SCREEN2	0x8003

#define USB_VENDOR_ID_PLAYDOTCOM	0x0b43
#define USB_DEVICE_ID_PLAYDOTCOM_EMS_USBII	0x0003

#define USB_VENDOR_ID_POWERCOM		0x0d9f
#define USB_DEVICE_ID_POWERCOM_UPS	0x0002

#define USB_VENDOR_ID_PRODIGE		0x05af
#define USB_DEVICE_ID_PRODIGE_CORDLESS	0x3062

#define USB_VENDOR_ID_QUANTA		0x0408
#define USB_DEVICE_ID_QUANTA_OPTICAL_TOUCH		0x3000
#define USB_DEVICE_ID_QUANTA_OPTICAL_TOUCH_3001		0x3001
#define USB_DEVICE_ID_QUANTA_OPTICAL_TOUCH_3003		0x3003
#define USB_DEVICE_ID_QUANTA_OPTICAL_TOUCH_3008		0x3008

#define I2C_VENDOR_ID_RAYDIUM		0x2386
#define I2C_PRODUCT_ID_RAYDIUM_4B33	0x4b33
#define I2C_PRODUCT_ID_RAYDIUM_3118	0x3118

#define USB_VENDOR_ID_RAZER            0x1532
#define USB_DEVICE_ID_RAZER_BLACKWIDOW_ULTIMATE   0x010D
#define USB_DEVICE_ID_RAZER_BLACKWIDOW            0x010e
#define USB_DEVICE_ID_RAZER_BLACKWIDOW_CLASSIC    0x011b
#define USB_DEVICE_ID_RAZER_BLADE_14   0x011D

#define USB_VENDOR_ID_REALTEK		0x0bda
#define USB_DEVICE_ID_REALTEK_READER	0x0152

#define USB_VENDOR_ID_REDOCTANE		0x1430
#define USB_DEVICE_ID_REDOCTANE_GUITAR_DONGLE	0x474c
#define USB_DEVICE_ID_REDOCTANE_PS4_GHLIVE_DONGLE	0x07bb

#define USB_VENDOR_ID_RETROUSB		0xf000
#define USB_DEVICE_ID_RETROUSB_SNES_RETROPAD	0x0003
#define USB_DEVICE_ID_RETROUSB_SNES_RETROPORT	0x00f1

#define USB_VENDOR_ID_ROCCAT		0x1e7d
#define USB_DEVICE_ID_ROCCAT_ARVO	0x30d4
#define USB_DEVICE_ID_ROCCAT_ISKU	0x319c
#define USB_DEVICE_ID_ROCCAT_ISKUFX	0x3264
#define USB_DEVICE_ID_ROCCAT_KONE	0x2ced
#define USB_DEVICE_ID_ROCCAT_KONEPLUS	0x2d51
#define USB_DEVICE_ID_ROCCAT_KONEPURE	0x2dbe
#define USB_DEVICE_ID_ROCCAT_KONEPURE_OPTICAL	0x2db4
#define USB_DEVICE_ID_ROCCAT_KONEXTD	0x2e22
#define USB_DEVICE_ID_ROCCAT_KOVAPLUS	0x2d50
#define USB_DEVICE_ID_ROCCAT_LUA	0x2c2e
#define USB_DEVICE_ID_ROCCAT_PYRA_WIRED	0x2c24
#define USB_DEVICE_ID_ROCCAT_PYRA_WIRELESS	0x2cf6
#define USB_DEVICE_ID_ROCCAT_RYOS_MK	0x3138
#define USB_DEVICE_ID_ROCCAT_RYOS_MK_GLOW	0x31ce
#define USB_DEVICE_ID_ROCCAT_RYOS_MK_PRO	0x3232
#define USB_DEVICE_ID_ROCCAT_SAVU	0x2d5a

#define USB_VENDOR_ID_SAI		0x17dd

#define USB_VENDOR_ID_SAITEK		0x06a3
#define USB_DEVICE_ID_SAITEK_RUMBLEPAD	0xff17
#define USB_DEVICE_ID_SAITEK_PS1000	0x0621
#define USB_DEVICE_ID_SAITEK_RAT7_OLD	0x0ccb
#define USB_DEVICE_ID_SAITEK_RAT7_CONTAGION	0x0ccd
#define USB_DEVICE_ID_SAITEK_RAT7	0x0cd7
#define USB_DEVICE_ID_SAITEK_RAT9	0x0cfa
#define USB_DEVICE_ID_SAITEK_MMO7	0x0cd0
#define USB_DEVICE_ID_SAITEK_X52	0x075c
#define USB_DEVICE_ID_SAITEK_X52_2	0x0255
#define USB_DEVICE_ID_SAITEK_X52_PRO	0x0762
#define USB_DEVICE_ID_SAITEK_X65	0x0b6a

#define USB_VENDOR_ID_SAMSUNG		0x0419
#define USB_DEVICE_ID_SAMSUNG_IR_REMOTE	0x0001
#define USB_DEVICE_ID_SAMSUNG_WIRELESS_KBD_MOUSE	0x0600

#define USB_VENDOR_ID_SEMICO			0x1a2c
#define USB_DEVICE_ID_SEMICO_USB_KEYKOARD	0x0023
#define USB_DEVICE_ID_SEMICO_USB_KEYKOARD2	0x0027

#define USB_VENDOR_ID_SEMITEK	0x1ea7
#define USB_DEVICE_ID_SEMITEK_KEYBOARD	0x0907

#define USB_VENDOR_ID_SENNHEISER	0x1395
#define USB_DEVICE_ID_SENNHEISER_BTD500USB	0x002c

#define USB_VENDOR_ID_SIGMA_MICRO	0x1c4f
#define USB_DEVICE_ID_SIGMA_MICRO_KEYBOARD	0x0002
#define USB_DEVICE_ID_SIGMA_MICRO_KEYBOARD2	0x0059

#define USB_VENDOR_ID_SIGMATEL		0x066F
#define USB_DEVICE_ID_SIGMATEL_STMP3780	0x3780

#define USB_VENDOR_ID_SIS_TOUCH		0x0457
#define USB_DEVICE_ID_SIS9200_TOUCH	0x9200
#define USB_DEVICE_ID_SIS817_TOUCH	0x0817
#define USB_DEVICE_ID_SIS_TS		0x1013
#define USB_DEVICE_ID_SIS1030_TOUCH	0x1030

#define USB_VENDOR_ID_SKYCABLE			0x1223
#define	USB_DEVICE_ID_SKYCABLE_WIRELESS_PRESENTER	0x3F07

#define USB_VENDOR_ID_SMK		0x0609
#define USB_DEVICE_ID_SMK_PS3_BDREMOTE	0x0306
#define USB_DEVICE_ID_SMK_NSG_MR5U_REMOTE       0x0368
#define USB_DEVICE_ID_SMK_NSG_MR7U_REMOTE       0x0369


#define USB_VENDOR_ID_SONY			0x054c
#define USB_DEVICE_ID_SONY_VAIO_VGX_MOUSE	0x024b
#define USB_DEVICE_ID_SONY_VAIO_VGP_MOUSE	0x0374
#define USB_DEVICE_ID_SONY_PS3_BDREMOTE		0x0306
#define USB_DEVICE_ID_SONY_PS3_CONTROLLER	0x0268
#define USB_DEVICE_ID_SONY_PS4_CONTROLLER	0x05c4
#define USB_DEVICE_ID_SONY_PS4_CONTROLLER_2	0x09cc
#define USB_DEVICE_ID_SONY_PS4_CONTROLLER_DONGLE	0x0ba0
#define USB_DEVICE_ID_SONY_PS5_CONTROLLER	0x0ce6
#define USB_DEVICE_ID_SONY_PS5_CONTROLLER_2	0x0df2
#define USB_DEVICE_ID_SONY_MOTION_CONTROLLER	0x03d5
#define USB_DEVICE_ID_SONY_NAVIGATION_CONTROLLER	0x042f
#define USB_DEVICE_ID_SONY_BUZZ_CONTROLLER		0x0002
#define USB_DEVICE_ID_SONY_WIRELESS_BUZZ_CONTROLLER	0x1000

#define USB_VENDOR_ID_SONY_RHYTHM	0x12ba
#define USB_DEVICE_ID_SONY_PS3WIIU_GHLIVE_DONGLE	0x074b
#define USB_DEVICE_ID_SONY_PS3_GUITAR_DONGLE	0x0100

#define USB_VENDOR_ID_SINO_LITE			0x1345
#define USB_DEVICE_ID_SINO_LITE_CONTROLLER	0x3008

#define USB_VENDOR_ID_SOLID_YEAR			0x060b
#define USB_DEVICE_ID_MACALLY_IKEY_KEYBOARD		0x0001
#define USB_DEVICE_ID_COUGAR_500K_GAMING_KEYBOARD	0x500a
#define USB_DEVICE_ID_COUGAR_700K_GAMING_KEYBOARD	0x700a

#define USB_VENDOR_ID_SOUNDGRAPH	0x15c2
#define USB_DEVICE_ID_SOUNDGRAPH_IMON_FIRST	0x0034
#define USB_DEVICE_ID_SOUNDGRAPH_IMON_LAST	0x0046

#define USB_VENDOR_ID_STANTUM		0x1f87
#define USB_DEVICE_ID_MTP		0x0002

#define USB_VENDOR_ID_STANTUM_STM		0x0483
#define USB_DEVICE_ID_MTP_STM		0x3261

#define USB_VENDOR_ID_STANTUM_SITRONIX		0x1403
#define USB_DEVICE_ID_MTP_SITRONIX		0x5001

#define USB_VENDOR_ID_VALVE			0x28de
#define USB_DEVICE_ID_STEAM_CONTROLLER		0x1102
#define USB_DEVICE_ID_STEAM_CONTROLLER_WIRELESS	0x1142
#define USB_DEVICE_ID_STEAM_DECK	0x1205

#define USB_VENDOR_ID_STEELSERIES	0x1038
#define USB_DEVICE_ID_STEELSERIES_SRWS1	0x1410

#define USB_VENDOR_ID_SUN		0x0430
#define USB_DEVICE_ID_RARITAN_KVM_DONGLE	0xcdab

#define USB_VENDOR_ID_SUNPLUS		0x04fc
#define USB_DEVICE_ID_SUNPLUS_WDESKTOP	0x05d8

#define USB_VENDOR_ID_SYMBOL		0x05e0
#define USB_DEVICE_ID_SYMBOL_SCANNER_1	0x0800
#define USB_DEVICE_ID_SYMBOL_SCANNER_2	0x1300
#define USB_DEVICE_ID_SYMBOL_SCANNER_3	0x1200

#define I2C_VENDOR_ID_SYNAPTICS     0x06cb
#define I2C_PRODUCT_ID_SYNAPTICS_SYNA2393   0x7a13

#define USB_VENDOR_ID_SYNAPTICS		0x06cb
#define USB_DEVICE_ID_SYNAPTICS_TP	0x0001
#define USB_DEVICE_ID_SYNAPTICS_INT_TP	0x0002
#define USB_DEVICE_ID_SYNAPTICS_CPAD	0x0003
#define USB_DEVICE_ID_SYNAPTICS_TS	0x0006
#define USB_DEVICE_ID_SYNAPTICS_STICK	0x0007
#define USB_DEVICE_ID_SYNAPTICS_WP	0x0008
#define USB_DEVICE_ID_SYNAPTICS_COMP_TP	0x0009
#define USB_DEVICE_ID_SYNAPTICS_WTP	0x0010
#define USB_DEVICE_ID_SYNAPTICS_DPAD	0x0013
#define USB_DEVICE_ID_SYNAPTICS_LTS1	0x0af8
#define USB_DEVICE_ID_SYNAPTICS_LTS2	0x1d10
#define USB_DEVICE_ID_SYNAPTICS_HD	0x0ac3
#define USB_DEVICE_ID_SYNAPTICS_QUAD_HD	0x1ac3
#define USB_DEVICE_ID_SYNAPTICS_DELL_K12A	0x2819
#define USB_DEVICE_ID_SYNAPTICS_ACER_SWITCH5_012	0x2968
#define USB_DEVICE_ID_SYNAPTICS_TP_V103	0x5710
#define USB_DEVICE_ID_SYNAPTICS_DELL_K15A	0x6e21
#define USB_DEVICE_ID_SYNAPTICS_ACER_ONE_S1002	0x73f4
#define USB_DEVICE_ID_SYNAPTICS_ACER_ONE_S1003	0x73f5
#define USB_DEVICE_ID_SYNAPTICS_ACER_SWITCH5_017	0x73f6
#define USB_DEVICE_ID_SYNAPTICS_ACER_SWITCH5	0x81a7

#define USB_VENDOR_ID_TEXAS_INSTRUMENTS	0x2047
#define USB_DEVICE_ID_TEXAS_INSTRUMENTS_LENOVO_YOGA	0x0855

#define USB_VENDOR_ID_THINGM		0x27b8
#define USB_DEVICE_ID_BLINK1		0x01ed

#define USB_VENDOR_ID_THQ		0x20d6
#define USB_DEVICE_ID_THQ_PS3_UDRAW	0xcb17

#define USB_VENDOR_ID_THRUSTMASTER	0x044f

#define USB_VENDOR_ID_TIVO		0x150a
#define USB_DEVICE_ID_TIVO_SLIDE_BT	0x1200
#define USB_DEVICE_ID_TIVO_SLIDE	0x1201
#define USB_DEVICE_ID_TIVO_SLIDE_PRO	0x1203

#define USB_VENDOR_ID_TOPRE			0x0853
#define USB_DEVICE_ID_TOPRE_REALFORCE_R2_108			0x0148

#define USB_VENDOR_ID_TOPSEED		0x0766
#define USB_DEVICE_ID_TOPSEED_CYBERLINK	0x0204

#define USB_VENDOR_ID_TOPSEED2		0x1784
#define USB_DEVICE_ID_TOPSEED2_RF_COMBO	0x0004
#define USB_DEVICE_ID_TOPSEED2_PERIPAD_701	0x0016

#define USB_VENDOR_ID_TOPMAX		0x0663
#define USB_DEVICE_ID_TOPMAX_COBRAPAD	0x0103

#define USB_VENDOR_ID_TOUCH_INTL	0x1e5e
#define USB_DEVICE_ID_TOUCH_INTL_MULTI_TOUCH	0x0313

#define USB_VENDOR_ID_TOUCHPACK		0x1bfd
#define USB_DEVICE_ID_TOUCHPACK_RTS	0x1688

#define USB_VENDOR_ID_TPV		0x25aa
#define USB_DEVICE_ID_TPV_OPTICAL_TOUCHSCREEN_8882	0x8882
#define USB_DEVICE_ID_TPV_OPTICAL_TOUCHSCREEN_8883	0x8883

#define USB_VENDOR_ID_TRUST             0x145f
#define USB_DEVICE_ID_TRUST_PANORA_TABLET   0x0212

#define USB_VENDOR_ID_TURBOX		0x062a
#define USB_DEVICE_ID_TURBOX_KEYBOARD	0x0201
#define USB_DEVICE_ID_ASUS_MD_5110	0x5110
#define USB_DEVICE_ID_TURBOX_TOUCHSCREEN_MOSART	0x7100

#define USB_VENDOR_ID_TWINHAN		0x6253
#define USB_DEVICE_ID_TWINHAN_IR_REMOTE	0x0100

#define USB_VENDOR_ID_UCLOGIC		0x5543
#define USB_DEVICE_ID_UCLOGIC_TABLET_PF1209	0x0042
#define USB_DEVICE_ID_UCLOGIC_TABLET_KNA5	0x6001
#define USB_DEVICE_ID_UCLOGIC_TABLET_TWA60	0x0064
#define USB_DEVICE_ID_UCLOGIC_TABLET_WP4030U	0x0003
#define USB_DEVICE_ID_UCLOGIC_TABLET_WP5540U	0x0004
#define USB_DEVICE_ID_UCLOGIC_TABLET_WP8060U	0x0005
#define USB_DEVICE_ID_UCLOGIC_TABLET_WP1062	0x0064
#define USB_DEVICE_ID_UCLOGIC_WIRELESS_TABLET_TWHL850	0x0522
#define USB_DEVICE_ID_UCLOGIC_TABLET_TWHA60	0x0781
#define USB_DEVICE_ID_UCLOGIC_DRAWIMAGE_G3	0x3031
#define USB_DEVICE_ID_UCLOGIC_UGEE_TABLET_81	0x0081
#define USB_DEVICE_ID_UCLOGIC_UGEE_TABLET_45	0x0045
#define USB_DEVICE_ID_UCLOGIC_UGEE_TABLET_47	0x0047
#define USB_DEVICE_ID_YIYNOVA_TABLET		0x004d

#define USB_VENDOR_ID_UGEE		0x28bd
#define USB_DEVICE_ID_UGEE_PARBLO_A610_PRO	0x1903
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_G540	0x0075
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_G640	0x0094
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO01	0x0042
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO01_V2	0x0905
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO_L	0x0935
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO_PRO_MW	0x0934
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO_PRO_S	0x0909
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_DECO_PRO_SW	0x0933
#define USB_DEVICE_ID_UGEE_XPPEN_TABLET_STAR06	0x0078
#define USB_DEVICE_ID_UGEE_TABLET_G5		0x0074
#define USB_DEVICE_ID_UGEE_TABLET_EX07S		0x0071
#define USB_DEVICE_ID_UGEE_TABLET_RAINBOW_CV720	0x0055

#define USB_VENDOR_ID_UNITEC	0x227d
#define USB_DEVICE_ID_UNITEC_USB_TOUCH_0709	0x0709
#define USB_DEVICE_ID_UNITEC_USB_TOUCH_0A19	0x0a19

#define USB_VENDOR_ID_VELLEMAN		0x10cf
#define USB_DEVICE_ID_VELLEMAN_K8055_FIRST	0x5500
#define USB_DEVICE_ID_VELLEMAN_K8055_LAST	0x5503
#define USB_DEVICE_ID_VELLEMAN_K8061_FIRST	0x8061
#define USB_DEVICE_ID_VELLEMAN_K8061_LAST	0x8068

#define USB_VENDOR_ID_VTL		0x0306
#define USB_DEVICE_ID_VTL_MULTITOUCH_FF3F	0xff3f

#define USB_VENDOR_ID_WACOM		0x056a
#define USB_DEVICE_ID_WACOM_GRAPHIRE_BLUETOOTH	0x81
#define USB_DEVICE_ID_WACOM_INTUOS4_BLUETOOTH   0x00BD

#define USB_VENDOR_ID_WALTOP				0x172f
#define USB_DEVICE_ID_WALTOP_SLIM_TABLET_5_8_INCH	0x0032
#define USB_DEVICE_ID_WALTOP_SLIM_TABLET_12_1_INCH	0x0034
#define USB_DEVICE_ID_WALTOP_Q_PAD			0x0037
#define USB_DEVICE_ID_WALTOP_PID_0038			0x0038
#define USB_DEVICE_ID_WALTOP_MEDIA_TABLET_10_6_INCH	0x0501
#define USB_DEVICE_ID_WALTOP_MEDIA_TABLET_14_1_INCH	0x0500
#define USB_DEVICE_ID_WALTOP_SIRIUS_BATTERY_FREE_TABLET	0x0502

#define	USB_VENDOR_ID_WEIDA		0x2575
#define	USB_DEVICE_ID_WEIDA_8752	0xC300
#define	USB_DEVICE_ID_WEIDA_8755	0xC301

#define USB_VENDOR_ID_WINBOND		0x0416
#define USB_DEVICE_ID_TSTP_MTOUCH	0xc168

#define USB_VENDOR_ID_WISEGROUP		0x0925
#define USB_DEVICE_ID_SMARTJOY_PLUS	0x0005
#define USB_DEVICE_ID_SUPER_JOY_BOX_3	0x8888
#define USB_DEVICE_ID_QUAD_USB_JOYPAD	0x8800
#define USB_DEVICE_ID_DUAL_USB_JOYPAD	0x8866

#define USB_VENDOR_ID_WISEGROUP_LTD	0x6666
#define USB_VENDOR_ID_WISEGROUP_LTD2	0x6677
#define USB_DEVICE_ID_SMARTJOY_DUAL_PLUS 0x8802
#define USB_DEVICE_ID_SUPER_JOY_BOX_3_PRO 0x8801
#define USB_DEVICE_ID_SUPER_DUAL_BOX_PRO 0x8802
#define USB_DEVICE_ID_SUPER_JOY_BOX_5_PRO 0x8804

#define USB_VENDOR_ID_WISTRON		0x0fb8
#define USB_DEVICE_ID_WISTRON_OPTICAL_TOUCH		0x1109

#define USB_VENDOR_ID_X_TENSIONS               0x1ae7
#define USB_DEVICE_ID_SPEEDLINK_VAD_CEZANNE    0x9001

#define USB_VENDOR_ID_XAT	0x2505
#define USB_DEVICE_ID_XAT_CSR	0x0220

#define USB_VENDOR_ID_XIAOMI		0x2717
#define USB_DEVICE_ID_MI_SILENT_MOUSE	0x5014

#define USB_VENDOR_ID_XIN_MO			0x16c0
#define USB_DEVICE_ID_XIN_MO_DUAL_ARCADE	0x05e1
#define USB_DEVICE_ID_THT_2P_ARCADE		0x75e1

#define USB_VENDOR_ID_XIROKU		0x1477
#define USB_DEVICE_ID_XIROKU_SPX	0x1006
#define USB_DEVICE_ID_XIROKU_MPX	0x1007
#define USB_DEVICE_ID_XIROKU_CSR	0x100e
#define USB_DEVICE_ID_XIROKU_SPX1	0x1021
#define USB_DEVICE_ID_XIROKU_CSR1	0x1022
#define USB_DEVICE_ID_XIROKU_MPX1	0x1023
#define USB_DEVICE_ID_XIROKU_SPX2	0x1024
#define USB_DEVICE_ID_XIROKU_CSR2	0x1025
#define USB_DEVICE_ID_XIROKU_MPX2	0x1026

#define USB_VENDOR_ID_YEALINK		0x6993
#define USB_DEVICE_ID_YEALINK_P1K_P4K_B2K	0xb001

#define USB_VENDOR_ID_ZEROPLUS		0x0c12

#define USB_VENDOR_ID_ZYDACRON	0x13EC
#define USB_DEVICE_ID_ZYDACRON_REMOTE_CONTROL	0x0006

#define USB_VENDOR_ID_ZYTRONIC		0x14c8
#define USB_DEVICE_ID_ZYTRONIC_ZXY100	0x0005

#define USB_VENDOR_ID_PRIMAX	0x0461
#define USB_DEVICE_ID_PRIMAX_MOUSE_4D22	0x4d22
#define USB_DEVICE_ID_PRIMAX_MOUSE_4E2A	0x4e2a
#define USB_DEVICE_ID_PRIMAX_KEYBOARD	0x4e05
#define USB_DEVICE_ID_PRIMAX_REZEL	0x4e72
#define USB_DEVICE_ID_PRIMAX_PIXART_MOUSE_4D0F	0x4d0f
#define USB_DEVICE_ID_PRIMAX_PIXART_MOUSE_4D65	0x4d65
#define USB_DEVICE_ID_PRIMAX_PIXART_MOUSE_4E22	0x4e22


#define USB_VENDOR_ID_RISO_KAGAKU	0x1294	/* Riso Kagaku Corp. */
#define USB_DEVICE_ID_RI_KA_WEBMAIL	0x1320	/* Webmail Notifier */

#define USB_VENDOR_ID_MULTIPLE_1781	0x1781
#define USB_DEVICE_ID_RAPHNET_4NES4SNES_OLD	0x0a9d
#define USB_DEVICE_ID_PHOENIXRC        0x0898

#define USB_VENDOR_ID_DRACAL_RAPHNET	0x289b
#define USB_DEVICE_ID_RAPHNET_2NES2SNES	0x0002
#define USB_DEVICE_ID_RAPHNET_4NES4SNES	0x0003

#define USB_VENDOR_ID_UGTIZER			0x2179
#define USB_DEVICE_ID_UGTIZER_TABLET_GP0610	0x0053
#define USB_DEVICE_ID_UGTIZER_TABLET_GT5040	0x0077
#define USB_DEVICE_ID_UGTIZER_TABLET_WP5540	0x0004

#define USB_VENDOR_ID_VIEWSONIC			0x0543
#define USB_DEVICE_ID_VIEWSONIC_PD1011		0xe621

#define USB_VENDOR_ID_SIGNOTEC			0x2133
#define USB_DEVICE_ID_SIGNOTEC_VIEWSONIC_PD1011	0x0018

#endif
